//"Final" Scene for March-April IRTC
//Render at 800x600, AA 0.3

#version 3.0

#include "colors.inc"
#include "glass.inc"
#include "woods.inc"
#include "stones.inc"
#include "finish.inc"
#include "textures.inc"
#include "skies.inc"
#include "fishy.inc"

global_settings{assumed_gamma 1.85}

// ----------------------------------------
#default{finish{phong 1.0}}

#declare textures=1
#declare hills=0
#declare mush=1
#declare arealight=0
#declare tunnel=1
#declare wall=1
#declare stairway=1
#declare fishies=1

camera
{
  location  <-10, 8, -38.0>
  direction 1.5*z
  right     4/3*x
  look_at   <5, 11, 0>
  focal_point <0,15,11>
//  aperture 0.175
  aperture 0.2
  blur_samples 100
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

#if(arealight=1)
light_source{0*x color rgb 1.0 area_light
  <8, 0, 0> <0, 0, 1000> 10, 10 adaptive 0 jitter
  translate <40, 1000, -40>
}
#end

#if(textures=1)
 #declare main_bld_tex=texture{T_Stone44 scale 30}
 #declare stair_tex=texture{T_Stone9}
 #declare glass_tex=texture{T_Green_Glass}
 #declare chrome_tex=texture{Brass_Metal}
 #declare ground_tex=texture{pigment{checker color Black color MidnightBlue scale 5} finish{reflection 0.15}}
 #declare sky_pig=pigment{Blue_Sky}
#else
 #declare main_bld_tex=texture{pigment{Yellow}}
 #declare stair_tex=texture{pigment{White}}
 #declare glass_tex=texture{pigment{Green}}
 #declare chrome_tex=texture{pigment{Red}}
 #declare ground_tex=texture{pigment{Pink}}
 #declare sky_pig=pigment{Blue}
#end

#declare stairs=object{
 union{
  #declare rise=1
  #declare run=0
  #while(run<18)
   box{<-2,0,run>,<2,rise,run+1>}
   #declare rise=rise+1
   #declare run=run+1
  #end
 }
}

#declare column=object{
 union{
  cone{<0,5,0>,0.875,<0,16,0>,0.75}
  intersection{
   cone{<0,16,0>,0.75,<0,18,0>,1}
   box{<-0.85,16,-0.85>,<0.85,18,0.85>}
  }
  torus{0.75,0.125 translate<0,16,0>}
  torus{0.875,0.125 translate<0,5.125,0>}
  box{<-1,0,-1>,<1,5,1>}
 }
}

#declare col_set=object{
 union{
  box{<-1.5,23,-1.5>,<11.5,24,1.5>}
  union{
   object{column}
   object{column translate<10,0,0>}
   difference{
    box{<-1,18,-1>,<11,23,1>}
    cylinder{<5,18,100>,<5,18,-100>,4}
   }
  }
  union{
   difference{
    box{<0,0,-0.5>,<10,4.5,0.5>}
    #declare chunk_trans=2.5
    #while(chunk_trans<=7.5)
     cylinder{<chunk_trans,3,100>,<chunk_trans,3,-100>,1}
     box{<chunk_trans-1,3,100>,<chunk_trans+1,-10,-100>}
     #declare chunk_trans=chunk_trans+2.5
    #end
   }
  }
 }
}

#if(stairway=1)
 object{stairs texture{stair_tex}}

 difference{
  union{
   box{<-2,0,-0.5>,<-2.5,20,30>}
   box{<2,0,-0.5>,<2.5,20,30>}
   box{<-2,0,30>,<-4,20,28>}
   box{<2,0,30>,<4,20,28>}
   cylinder{<-2.25,20,30>,<-2.25,20,0>,0.25}
   cylinder{<2.25,20,30>,<2.25,20,0>,0.25}
  }
  box{<-5,-5,0>,<5,30,-50> rotate x*45 translate y*3}
  cylinder{<-4,0,28>,<-4,50,28>,2}
  cylinder{<4,0,28>,<4,50,28>,2}
  texture{main_bld_tex}
 }

 union{
  difference{
   union{
    cylinder{<-2.25,-5,0>,<-2.25,28,0>,0.25 rotate x*45 translate y*3}
    cylinder{<2.25,-5,0>,<2.25,28,0>,0.25 rotate x*45 translate y*3}
   }
   box{<-100,20,-100>,<100,100,100>}
  }
  box{<-2,3,0.5>,<-2.5,0,-5>}
  box{<2,3,0.5>,<2.5,0,-5>}
  cylinder{<-2.25,0,-5>,<-2.25,3,-5>,0.25}
  cylinder{<2.25,0,-5>,<2.25,3,-5>,0.25}
  texture{main_bld_tex}
 }

 union{
  torus{0.25,0.25 translate<-2.25,0,-5>}
  torus{0.25,0.25 translate<2.25,0,-5>}
  cylinder{<-2.25,0,-5>,<-2.25,0,30>,0.25}
  cylinder{<2.25,0,-5>,<2.25,0,30>,0.25}
  cylinder{<-2.5,0,-5>,<-2.25,0,30>,0.25}
  cylinder{<2.5,0,-5>,<2.25,0,30>,0.25}
  cylinder{<-2,0,-5>,<-2,0,30>,0.25}
  cylinder{<2,0,-5>,<2,0,30>,0.25}
  texture{stair_tex}
 }

 union{
  cylinder{<-2.25,3,-5>,<-2.25,3,30>,0.25}
  cylinder{<2.25,3,-5>,<2.25,3,30>,0.25}
  sphere{<-2.25,3,-5>,0.25}
  sphere{<2.25,3,-5>,0.25}
  texture{main_bld_tex}
 }

 difference{
  box{<-2.5,0,17>,<2.5,20,30>}
  box{<-2,17,-50>,<2.5,30,50>}
  texture{main_bld_tex}
 }

 difference{
  union{
  difference{
   box{<-4.5,0,0>,<-2.5,2,30>}
   cylinder{<-4.5,2,-100>,<-4.5,2,100>,1.75}
   texture{stair_tex}
  }
   difference{
   box{<4.5,0,0>,<2.5,2,30>}
   cylinder{<4.5,2,-100>,<4.5,2,100>,1.75}
  }
 }
 box{<-10,-10,2>,<10,10,4>}
 box{<-10,-10,6>,<10,10,8>}
 box{<-10,-10,10>,<10,10,12>}
 box{<-10,-10,14>,<10,10,16>}
 box{<-10,-10,18>,<10,10,20>}
 box{<-10,-10,22>,<10,10,24>}
 box{<-10,-10,26>,<10,10,28>}
 texture{stair_tex}
}

union{
 cylinder{<3,0.5,30.5>,<3,0.5,-1>,0.125}
 cylinder{<-3,0.5,30.5>,<-3,0.5,-1>,0.125}
 sphere{<-3,0.5,-1>,0.125}
 sphere{<3,0.5,-1>,0.125}
 texture{chrome_tex}
}
#end

union{
 difference{
  box{<-5,0,30>,<5,30,50>}		        //main bldg box
  box{<-3,0,32>,<-10,50,0>}
  box{<3,0,32>,<10,50,0>}
  box{<-3,0,48>,<-10,50,100>}
  box{<3,0,48>,<10,50,100>}
  box{<-4,1,31>,<4,29,49>}		        //hollow it out
  box{<-1.75,17,-50>,<1.75,25,35>}	    //door
  cylinder{<0,25,-50>,<0,25,35>,1.75}	//door arch
 }
 union{
  cylinder{<-1.75,0,30.5>,<-1.75,25,30.5>,0.5}
  cylinder{<1.75,0,30.5>,<1.75,25,30.5>,0.5}
  difference{
   torus{1.75, 0.5 rotate x*90 translate<0,25,30.5>}
   box{<-100,-100,-100>,<100,25,100>}
  }
 }
 difference{
  union{
   cylinder{<-3,0,32>,<-3,30,32>,2}
   cylinder{<3,0,32>,<3,30,32>,2}
   cylinder{<-3,0,48>,<-3,30,48>,2}
   cylinder{<3,0,48>,<3,30,48>,2}
   cylinder{<-3,30,32>,<3,30,32>,2}
   cylinder{<-3,30,32>,<-3,30,50>,2}
   cylinder{<3,30,32>,<3,30,50>,2}
   sphere{<-3,30,32>,2}
   sphere{<3,30,32>,2}
   sphere{<-3,30,48>,2}
   sphere{<3,30,48>,2}
  }
  box{<-3,1,-100>,<3,29,100>}
 }
 cylinder{<-6,2.25,40>,<6,2.25,40>,1}
 cylinder{<-6,7.25,40>,<6,7.25,40>,1}
 cylinder{<-6,12.25,40>,<6,12.25,40>,1}
 texture{main_bld_tex}
}

union{
 sphere{<-6,2.25,40>,0.75}
 sphere{<-6,7.25,40>,0.75}
 sphere{<-6,12.25,40>,0.75}
 sphere{<6,2.25,40>,0.75}
 sphere{<6,7.25,40>,0.75}
 sphere{<6,12.25,40>,0.75}
 texture{glass_tex}
}

#declare building_ring=object{
 union{
  difference{
   union{
    box{<-3,0,50.5>,<3,-2,29.5>}
    box{<-5.5,0,48>,<5.5,-2,32>}
    cylinder{<-3,0,48>,<-3,-2,48>,2.5}
    cylinder{<-3,0,32>,<-3,-2,32>,2.5}
    cylinder{<3,0,48>,<3,-2,48>,2.5}
    cylinder{<3,0,32>,<3,-2,32>,2.5}
   }
   intersection{
    torus{3,1 translate<-3,-2,32>}
    box{<-100,-100,-100>,<-3.5,100,31.5>}
   }
   intersection{
    torus{3,1 translate<3,-2,32>}
    box{<100,100,-100>,<3.5,-100,31.5>}
   }
   intersection{
    torus{3,1 translate<-3,-2,48>}
    box{<-100,-100,100>,<-3.5,100,48.5>}
   }
   intersection{
    torus{3,1 translate<3,-2,48>}
    box{<100,-100,100>,<3.5,100,48.5>}
   }
   cylinder{<-6,-2,100>,<-6,-2,-100>,1}
   cylinder{<6,-2,100>,<6,-2,-100>,1}
   cylinder{<-100,-2,51>,<100,-2,51>,1}
   cylinder{<-100,-2,29>,<100,-2,29>,1}
  }
  union{
   box{<-3,0.5,50>,<3,0,30>}
   box{<-5,0.5,48>,<5,0,32>}
   cylinder{<-3,0.5,48>,<-3,0,48>,2}
   cylinder{<-3,0.5,32>,<-3,0,32>,2}
   cylinder{<3,0.5,48>,<3,0,48>,2}
   cylinder{<3,0.5,32>,<3,0,32>,2}
  }
  union{
   torus{2,0.5 translate<-3,0,32>}
   torus{2,0.5 translate<3,0,32>}
   torus{2,0.5 translate<-3,0,48>}
   torus{2,0.5 translate<3,0,48>}
   cylinder{<-5,0,32>,<-5,0,50>,0.5}
   cylinder{<5,0,32>,<5,0,50>,0.5}
   cylinder{<-3,0,30>,<3,0,30>,0.5}
   cylinder{<-3,0,50>,<3,0,50>,0.5}
  }
 }
}

union{
 object{building_ring translate y*0}
 object{building_ring translate y*5}
 object{building_ring translate y*10}
 object{building_ring translate y*15}
 object{building_ring translate y*30}
 texture{main_bld_tex}
}

#if(tunnel=1)
 difference{
  cylinder{<5,19,40>,<600,19,40>,8}
  box{<-100,18,-100>,<700,100,100>}
  texture{main_bld_tex}
 }
 difference{
  cylinder{<5,19,40>,<600,19,40>,7.5}
  cylinder{<4,19,40>,<700,19,40>,7.25}
  texture{glass_tex}
 }

 difference{
  cylinder{<5,19,40>,<600,19,40>,9}
  box{<-100,18.5,-100>,<700,100,100>}
  cylinder{<-1000,18.5,31>,<1000,18.5,31>,0.5}
  cylinder{<-1000,18.5,49>,<1000,18.5,49>,0.5}
  #declare tun_chunk=-2.5
  #while(tun_chunk<=200)
   box{<0,100,100>,<5,-100,-100> translate x*tun_chunk}
   #declare tun_chunk=tun_chunk+10
  #end
  texture{stair_tex}
 }

 union{
  #declare tun_chunk=5
  #while(tun_chunk<=200)
   sphere{<0,0,0>,1.0 translate<tun_chunk,16.75,31.5>}
   cylinder{<0,0,0>,<0,-2,0>,1.0 translate<tun_chunk,16.75,31.5>}
   torus{0.75, 0.25 translate<tun_chunk,14.75,31.5>}
   #declare tun_chunk=tun_chunk+10
  #end
  texture{stair_tex}
 }

 union{
  cylinder{<5,5,31.5>,<65,5,31.5>,0.375}
  cylinder{<5,5,48.5>,<65,5,48.5>,0.375}
  cylinder{<5,10,31.5>,<65,10,31.5>,0.375}
  cylinder{<5,10,48.5>,<65,10,48.5>,0.375}
  texture{chrome_tex}
 }

 #declare pole_trans=5
 #while(pole_trans<=75)
  union{
   cylinder{<pole_trans,-10,48.5>,<pole_trans,16,48.5>,0.75}
   cylinder{<pole_trans,-10,31.5>,<pole_trans,16,31.5>,0.75}
   cylinder{<pole_trans,5,48.5>,<pole_trans,10,31.5>,0.375}
   cylinder{<pole_trans,5,31.5>,<pole_trans,10,48.5>,0.375}
   texture{chrome_tex}
  }
  #declare pole_trans=pole_trans+10
 #end
#end

difference{
 plane{y,0}
 box{<18,100,-10000>,<100,-100,10000>}
 texture{ground_tex}
}

box{<18,-1,-1000>,<100,-100,1000> texture{Water}}
box{<18,-20,-1000>,<100,-100,1000> texture{ground_tex}}

#declare light_bub=object{
union{
 sphere{<0,1,0>,0.75 texture{glass_tex}}
 difference{
  union{
   torus{1.25, 0.125 rotate z*90 translate y*1}
   torus{1.25, 0.125 rotate x*90 translate y*1}
  }
  box{<5,0,5>,<-5,-5,-5>}
  texture{chrome_tex}
 }
 union{
  cylinder{<-1.25,1,0>,<-1.25,0,0>,0.125}
  cylinder{<1.25,1,0>,<1.25,0,0>,0.125}
  cylinder{<0,1,-1.25>,<0,0,-1.25>,0.125}
  cylinder{<0,1,1.25>,<0,0,1.25>,0.125}
  cylinder{<0,0,0>,<0,-2.5,0>,1.3}
  texture{chrome_tex}
 }
}
}

object{light_bub translate<0,32.5,35>}

sky_sphere{pigment{sky_pig rotate y*50}}

//***MUSHROOMS!!!***

#if(mush=1)
 #declare R1 = seed(5521)
 #declare counter=0
 #while(counter<500)
  #declare stem=(rand(R1)*0.70)+0.25
  #declare headstart=(rand(R1)*1)+1
  #declare headheight=(rand(R1)*2)+1.75
  #declare headspread=(rand(R1)*2)+0.75
 lathe {
   quadratic_spline 6,<0,0>,<stem,0>,<stem,headstart>,<headspread,headstart+0.15> ,<headspread*0.6666, headstart+(headheight*0.35)>, <0, headstart+(headheight*0.5)> // the list of <u,v> points
   texture{pigment{gradient y color_map {[0.1 color rgb<1,rand(R1)*0.25,rand(R1)*0.15>] [0.5 color rgb <(rand(R1)*0.05)+0.95,(rand(R1)*0.05)+0.95,(rand(R1)*0.30)+0.70>]}
   turbulence 0.5 scale <1,3,1>} normal{marble turbulence 0.5 scale <1,3,1>} finish{ambient 0.2 specular 0.6}}
   scale 0.25 translate<(rand(R1)*45)-27,0,(rand(R1)*240)-40>}
 lathe {
   quadratic_spline 6,<0,0>,<stem,0>,<stem,headstart>,<headspread,headstart+0.15> ,<headspread*0.6666, headstart+(headheight*0.35)>, <0, headstart+(headheight*0.5)> // the list of <u,v> points
   texture{pigment{gradient y color_map {[0.1 color rgb<1,rand(R1)*0.25,rand(R1)*0.15>] [0.5 color rgb <(rand(R1)*0.05)+0.95,(rand(R1)*0.05)+0.95,(rand(R1)*0.30)+0.70>]}
   turbulence 0.5 scale <1,3,1>} normal{marble turbulence 0.5 scale <1,3,1>} finish{ambient 0.2 specular 0.6}}
   scale 0.25 translate<(rand(R1)*300)+101,0,(rand(R1)*5000)-40>}
  #declare counter=counter+1
 #end
#end

//**sample hills***
#if(hills=1)
 sphere{<10,0,1000>,50 scale x*2  texture{ground_tex}}
 sphere{<5,0,960>,30 scale x*2  texture{ground_tex}}
 sphere{<200,0,1000>,50 scale x*2.5  texture{ground_tex}}
 sphere{<220,0,960>,20 scale x*1.75  texture{ground_tex}}

#end
//**

#if(fishies=1)
 object{fishy rotate y*-90 rotate x*-45 scale 0.125 translate<-1.26,7,4>}
 object{fishy rotate y*-91 rotate x*-45 scale 0.105 translate<1.15,14,10>}
 object{fishy rotate y*-90 rotate x*-45 scale 0.05 translate<-1.35,15,11>}
 object{fishy rotate y*-90 rotate x*-45 scale 0.075 translate<0.25,16,10>}
 object{fishy rotate y*-89 rotate x*-45 scale 0.115 translate<-0.5,18,14>}
 object{fishy rotate y*230 scale 0.105 translate<6,3,-6>}
 object{fishy rotate y*250 scale 0.09 translate<1,2.45,-5>}

 #declare R1=seed(31.56)
 #declare fish_count=0
 #while(fish_count<=50)
  object{fishy scale (0.10*rand(R1))+0.025 translate<(rand(R1)*70)+5,(rand(R1)*10)+14,(rand(R1)*12)+34>}
  #declare fish_count=fish_count+1
 #end
#end

#if(wall=1)
 union{
  object{col_set translate<10,0,200>}
  object{col_set translate<0,0,200>}
  object{col_set translate<-10,0,200>}
  object{col_set translate<-20,0,200>}
  object{col_set translate<-30,0,200>}
  object{col_set translate<-40,0,200>}
  object{col_set translate<-50,0,200>}
  object{col_set translate<10,0,300>}
  object{col_set translate<0,0,300>}
  object{col_set translate<-10,0,300>}
  object{col_set translate<-20,0,300>}
  object{col_set translate<-30,0,300>}
  object{col_set translate<-40,0,300>}
  object{col_set translate<-50,0,300>}
  box{<-51.5,23,198.5>,<21.5,24,301.5>}
  texture{main_bld_tex}
 }
#end
